package org.codefilarete.stalactite.sql.ddl;

import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.structure.Column;

public class OracleDDLTableGenerator extends DDLTableGenerator {
	
	public OracleDDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
		super(typeMapping, dmlNameProviderFactory);
	}
	
	/**
	 * Overridden to take identity column into account : Oracle script must be adapted
	 */
	@Override
	protected String getSqlType(Column column) {
		String sqlType = super.getSqlType(column);
		if (column.isAutoGenerated()) {
			sqlType += " GENERATED BY DEFAULT ON NULL AS IDENTITY";
		}
		return sqlType;
	}
}
